<?php
include("conn.php");

// Function to log errors with more detail
function logError($message, $query = '') {
    $logFile = __DIR__ . '/error_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] ERROR: $message";
    if ($query) {
        $logMessage .= "\nQuery: $query";
    }
    file_put_contents($logFile, $logMessage . "\n", FILE_APPEND);
}

// Function to log success messages
function logSuccess($message) {
    $logFile = __DIR__ . '/success_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] SUCCESS: $message\n", FILE_APPEND);
}

// Function to get betting amounts with error handling
function getBettingAmount($conn, $periodId, $betType) {
    $periodId = mysqli_real_escape_string($conn, $periodId);
    $betType = mysqli_real_escape_string($conn, $betType);
    
    $query = "SELECT COALESCE(SUM(hodikemadida), 0) as total 
              FROM betting_details 
              WHERE atadaaidi = '$periodId' 
              AND bet_type = '$betType'";
              
    $result = mysqli_query($conn, $query);
    
    if (!$result) {
        logError("Failed to get betting amount", $query);
        return 0;
    }
    
    $row = mysqli_fetch_assoc($result);
    return floatval($row['total']);
}

// Calculate potential payout for a number
function calculatePayoutForNumber($conn, $periodId, $number) {
    $totalPayout = 0;
    
    try {
        // Direct number bet (9x)
        $totalPayout += getBettingAmount($conn, $periodId, "number$number") * 9;
        
        // Color bets (2x)
        if (in_array($number, [1,3,5,7,9])) {
            $totalPayout += getBettingAmount($conn, $periodId, 'green') * 2;
        }
        if (in_array($number, [0,2,4,6,8])) {
            $totalPayout += getBettingAmount($conn, $periodId, 'red') * 2;
        }
        
        // Violet numbers (4.5x)
        if (in_array($number, [0,5])) {
            $totalPayout += getBettingAmount($conn, $periodId, 'violet') * 4.5;
        }
        
        // Size bets (2x)
        if (in_array($number, [0,1,2,3,4])) {
            $totalPayout += getBettingAmount($conn, $periodId, 'small') * 2;
        }
        if (in_array($number, [5,6,7,8,9])) {
            $totalPayout += getBettingAmount($conn, $periodId, 'big') * 2;
        }
        
        return $totalPayout;
        
    } catch (Exception $e) {
        logError("Error in calculatePayoutForNumber: " . $e->getMessage());
        return PHP_FLOAT_MAX;
    }
}

try {
    // Get current period ID
    $periodQuery = "SELECT atadaaidi FROM gelluonduhogu_zehn 
                   ORDER BY kramasankhye DESC LIMIT 1";
    $periodResult = mysqli_query($conn, $periodQuery);
    
    if (!$periodResult || mysqli_num_rows($periodResult) == 0) {
        throw new Exception("Could not get current period ID");
    }
    
    $periodRow = mysqli_fetch_assoc($periodResult);
    $currentPeriodId = $periodRow['atadaaidi'];
    
    // Calculate payouts for all numbers
    $payouts = [];
    for ($i = 0; $i <= 9; $i++) {
        $payouts[$i] = calculatePayoutForNumber($conn, $currentPeriodId, $i);
    }
    
    // Find number with minimum payout
    $bestNumber = array_search(min($payouts), $payouts);
    
    // Begin transaction
    mysqli_begin_transaction($conn);
    
    try {
        // Reset all predictions
        $resetQuery = "UPDATE hastacalita_phalitansa_zehn SET sthiti = '0'";
        if (!mysqli_query($conn, $resetQuery)) {
            throw new Exception("Failed to reset predictions");
        }
        
        // Set new prediction
        $updateQuery = "UPDATE hastacalita_phalitansa_zehn 
                       SET sthiti = '1' 
                       WHERE sankhye = '$bestNumber'";
                       
        if (!mysqli_query($conn, $updateQuery)) {
            throw new Exception("Failed to set new prediction");
        }
        
        // Commit transaction
        mysqli_commit($conn);
        
        logSuccess("Set prediction to $bestNumber (Payout: {$payouts[$bestNumber]})");
        
    } catch (Exception $e) {
        mysqli_rollback($conn);
        throw $e;
    }
    
} catch (Exception $e) {
    logError("Main process error: " . $e->getMessage());
    
} finally {
    if (isset($conn) && $conn) {
        mysqli_close($conn);
    }
}
?>